
unit defFnt;

{-----------------------------------------------------------------------
define font -

defines EGA/VGA font with some characters changed for the gnasher
program. The font is in the file GNASH.FNT which can be produced/changed
for instance by the excellent program EGAFONT by Aaron M. Williams
(EGAFONT.ZIP in PsL's PRGMMING\DOS\PASCAL directory).
-------------------------------------------------------------------------}

{$A+,B-,D+,E-,F-,I+,L-,N-,O-,R-,S-,V+}
{$M 4000,0,0}

interface
procedure DefineFont;

implementation
uses
  crt,dos;
var
  regs     : registers;
  f        : file;
  buffer   : array[0..8191] of byte;
  fileName : string[40];
  i,x,y    : integer;

procedure DefineFont;
begin
  with regs do begin
    assign(F,'gnash.fnt');
    {$I-}
    reset(F,1);
    {$I+}
    If IOResult <> 0 then begin
       write('Gnash.fnt not found'); halt;
    end
    else begin
      BP := Ofs(Buffer[0]);
      ES := Seg(Buffer[0]);
      BH := FileSize(F) shr 8;
        blockRead(f,buffer,FileSize(F));
      AX := $FFFF;
      intr($10,Regs);
      if AX <> $1234 then
      begin
        CX := 256;
        DX := 0;
        BL := 0;
        AH := $11;
        AL := $10;
        intr(16,Regs);
      end
      else
        If FileSize(F) <= 8192 then
        begin
          mem[ES:DX] := FileSize(F) shr 8;
          move(Buffer,Mem[ES:BX],FileSize(F));
          AH := $0F;
          Intr($10,Regs);
          AH := $00;
          intr($10,Regs);
        end;
    end;
  end;
end; {DefineFont}

end. {unit defFnt}

